<?php
require_once __DIR__ . '/../../functions.php';
session_start();
if (empty($_SESSION['admin'])) { http_response_code(403); exit('Forbidden'); }

$name = trim($_POST['name'] ?? '');
$info = trim($_POST['info'] ?? '');
if (!preg_match('/^[a-zA-Z0-9_\-]{3,100}$/', $name)) { http_response_code(400); exit('Bad name'); }

if (!isset($_FILES['file']) || $_FILES['file']['error'] !== UPLOAD_ERR_OK) {
  http_response_code(400); exit('No file');
}

$ext = strtolower(pathinfo($_FILES['file']['name'], PATHINFO_EXTENSION));
$targetPhp = __DIR__ . '/../../playlist/' . $name . '.php';

if ($ext === 'php') {
  move_uploaded_file($_FILES['file']['tmp_name'], $targetPhp);
} else if (in_array($ext, ['m3u','m3u8'])) {
  $raw = file_get_contents($_FILES['file']['tmp_name']);
  $escaped = str_replace(['\\', "'"], ['\\\\', "\\'"], $raw);
  $php = "<?php\nheader('Content-Type: application/vnd.apple.mpegurl');\necho '" . $escaped . "';\n";
  file_put_contents($targetPhp, $php);
} else {
  http_response_code(400); exit('Bad extension');
}

$ins = $pdo->prepare("INSERT INTO playlists (name, info, filename) VALUES (?,?,?) ON DUPLICATE KEY UPDATE info=VALUES(info), filename=VALUES(filename)");
$ins->execute([$name, $info, $name . '.php']);

header('Location: ../playlists.php');