<?php
error_reporting(E_ALL);
ini_set('display_errors', 1);

require_once __DIR__ . '/../../functions.php';
session_start();

if (empty($_SESSION['admin'])) { 
    http_response_code(403);
    exit('Forbidden');
}

$flag = 'start';
$logses = 0;
$username = trim($_POST['username'] ?? '');
$expire   = trim($_POST['expiredate'] ?? '');
$playlist = trim($_POST['playlist'] ?? '');
$limit    = (int)($_POST['device_limit'] ?? 1);

// Validasi dasar
if (!valid_username($username)) {
    http_response_code(400);
    exit('Username invalid (5–10 karakter, huruf/angka)');
}

$expYmd = parse_date_dmy($expire);
if (!$expYmd) {
    http_response_code(400);
    exit('Expiredate invalid (gunakan format dd/mm/yyyy)');
}

// Pastikan username unik
$stmt = $pdo->prepare("SELECT 1 FROM users WHERE username=?");
$stmt->execute([$username]);
if ($stmt->fetch()) {
    http_response_code(409);
    exit('Username sudah ada di database');
}

// Pastikan playlist valid
$chk = $pdo->prepare("SELECT 1 FROM playlists WHERE name=?");
$chk->execute([$playlist]);
if (!$chk->fetch()) {
    http_response_code(400);
    exit('Playlist tidak ditemukan di folder playlist');
}

// ✅ Query fix: 6 kolom, 6 placeholder, 6 nilai
$ins = $pdo->prepare("
    INSERT INTO users (flag, logses, username, expiredate, playlist, device_limit)
    VALUES (?, ?, ?, ?, ?, ?)
");
$ins->execute([$flag, $logses, $username, $expYmd, $playlist, $limit]);

echo 'OK';
