<?php include 'header.php'; ?>
<section class="content">
  <div class="container-fluid">
    <div class="mb-3">
      <button class="btn btn-success" data-toggle="modal" data-target="#modalAdd">Tambah Playlist</button>
    </div>
    <div class="card">
      <div class="card-body table-responsive p-0">
        <table class="table table-hover text-nowrap">
          <thead><tr><th>No.</th><th>Nama Playlist</th><th>Info</th><th>Aksi</th></tr></thead>
          <tbody>
          <?php
          $rows = $pdo->query("SELECT * FROM playlists ORDER BY id DESC")->fetchAll();
          $i=1;
          foreach ($rows as $r):
          ?>
            <tr>
              <td><?= $i++ ?></td>
              <td><?= htmlspecialchars($r['name']) ?></td>
              <td><?= htmlspecialchars($r['info'] ?? '-') ?></td>
              <td><button class="btn btn-sm btn-danger" onclick="delPl(<?=intval($r['id'])?>)">Hapus</button></td>
            </tr>
          <?php endforeach; ?>
          </tbody>
        </table>
      </div>
    </div>
  </div>
</section>

<div class="modal fade" id="modalAdd">
  <div class="modal-dialog">
    <form class="modal-content" method="post" action="api/playlist_upload.php" enctype="multipart/form-data">
      <div class="modal-header"><h5 class="modal-title">Tambah Playlist</h5><button type="button" class="close" data-dismiss="modal">&times;</button></div>
      <div class="modal-body">
        <div class="form-group">
          <label>Nama Playlist</label>
          <input name="name" class="form-control" required>
        </div>
        <div class="form-group">
          <label>Keterangan</label>
          <textarea name="info" class="form-control" rows="3"></textarea>
        </div>
        <div class="form-group">
          <label>Pilih File (.m3u, .m3u8, .php)</label>
          <input type="file" name="file" class="form-control" accept=".m3u,.m3u8,.php" required>
        </div>
      </div>
      <div class="modal-footer">
        <button class="btn btn-secondary" type="button" data-dismiss="modal">Batal</button>
        <button class="btn btn-primary">Simpan</button>
      </div>
    </form>
  </div>
</div>

<script>
function delPl(id){
  if(!confirm('Hapus playlist?')) return;
  fetch('api/playlist_delete.php',{method:'POST',body:new URLSearchParams({id:id})}).then(r=>r.text()).then(t=>location.reload());
}
</script>
<?php include 'footer.php'; ?>